#ifdef GL_ES
precision mediump float;
#endif

// output from the vertex shader (fragment color and texture coordinates)
varying vec4 v_fragmentColor;
varying vec2 v_texCoord;

uniform vec2 u_texture_steps;

const float dist_f = 2.25;


float get_a(vec2 offset) {
	float a = texture2D(CC_Texture0, v_texCoord + offset).a;
	a = floor(a);
	return a;
}


float compute_outline() {
	float sx = u_texture_steps.x * dist_f;
	float sy = u_texture_steps.y * dist_f;
	float a1 = 0.0;
	float a2 = 0.0;
	float a3 = 0.0;

	// 1
	a1 += get_a(vec2(0.0, +sy));
	a1 += get_a(vec2(0.0, -sy));
	a1 += get_a(vec2(+sx, 0.0));
	a1 += get_a(vec2(-sx, 0.0));

	// 2
	a2 += get_a(vec2(sx *  0.00000000, sy *  2.00000000));
	a2 += get_a(vec2(sx *  1.41421356, sy *  1.41421356));
	a2 += get_a(vec2(sx *  2.00000000, sy *  0.00000000));
	a2 += get_a(vec2(sx *  1.41421356, sy * -1.41421356));
	a2 += get_a(vec2(sx *  0.00000000, sy * -2.00000000));
	a2 += get_a(vec2(sx * -1.41421356, sy * -1.41421356));
	a2 += get_a(vec2(sx * -2.00000000, sy *  0.00000000));
	a2 += get_a(vec2(sx * -1.41421356, sy *  1.41421356));

	// 3
	a3 += get_a(vec2(sx *  0.00000000, sy *  3.00000000));
	a3 += get_a(vec2(sx *  1.50000000, sy *  2.59807621));
	a3 += get_a(vec2(sx *  2.59807621, sy *  1.50000000));
	a3 += get_a(vec2(sx *  3.00000000, sy *  0.00000000));
	a3 += get_a(vec2(sx *  2.59807621, sy * -1.50000000));
	a3 += get_a(vec2(sx *  1.50000000, sy * -2.59807621));
	a3 += get_a(vec2(sx *  0.00000000, sy * -3.00000000));
	a3 += get_a(vec2(sx * -1.50000000, sy * -2.59807621));
	a3 += get_a(vec2(sx * -2.59807621, sy * -1.50000000));
	a3 += get_a(vec2(sx * -3.00000000, sy *  0.00000000));
	a3 += get_a(vec2(sx * -2.59807621, sy *  1.50000000));
	a3 += get_a(vec2(sx * -1.50000000, sy *  2.59807621));

	// different weights per radius
	const float m1 = 3.0;
	const float m2 = 2.0;
	const float m3 = 1.0;
	const float div = ((4.0*m1) + (8.0*m2) + (12.0*m3)) / 2.0;

	float a = 0.0;
	a += (a1 * m1);
	a += (a2 * m2);
	a += (a3 * m3);
	a /= div;

	/*
	float a = 0.0;
	a += ceil(a1 /  4.0);
	a += ceil(a2 /  8.0);
	a += ceil(a3 / 12.0) * 0.5;
	*/

	a = clamp(a, 0.0, 1.0);

	return a;
}


// main shader function
void main() {
	vec4 texel = texture2D(CC_Texture0, v_texCoord);

	float outline_intensity = compute_outline();
	vec4 outline_color = v_fragmentColor;
	vec4 outline = outline_color * vec4(vec3(1.0), outline_intensity);

	if(outline.a == 0.0) {
		discard;
	}
	gl_FragColor = outline;
	//gl_FragColor = texel;
}
